/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.xml.Element;
import com.arsdigita.xml.Document;
import com.arsdigita.util.UncheckedWrapperException;
import javax.xml.parsers.ParserConfigurationException;
import javax.servlet.ServletException;

/**
 *  Demarcates the
 * position of a slave page subtree inside another page's component
 * tree.  Its generateXML method does nothing but call generateXML on
 * the input page.
 */
public class SlaveComponent extends SimpleComponent {

    private final static String SLAVE_ATTRIBUTE =
        "com.arsdigita.bebop.SlavePage";

    private Page m_slavePage;

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SlaveComponent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public SlaveComponent() {
        super();
    }

    public SlaveComponent(Page p) {
        this();
        m_slavePage = p;
    }

    public void generateXML(PageState ps, Element parent) {
        if (m_slavePage == null) {
            m_slavePage =
                (Page)ps.getRequest().getAttribute(SLAVE_ATTRIBUTE);
        }

        // document parameter will be ignored
        // except we'll waste some effort calling setRootNode and
        // then re-importing the created notes into a new document
        try {
            Document doc = new Document();
            PageState slaveState =
                m_slavePage.prepare(ps.getRequest(), ps.getResponse());
            m_slavePage.generateXML(slaveState, doc);
            parent.addContent(doc.getRootElement());
        } catch (ParserConfigurationException pce) {
            // TODO: log error
            parent.addContent(new Element("b").setText(pce.toString()));
        } catch (ServletException se) {
            throw new UncheckedWrapperException(se);
        }
    }
}
