/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import java.util.Iterator;
import com.arsdigita.xml.Element;
import com.arsdigita.persistence.DataQuery;

/**
 * .  A
 * container that outputs its components repeatedly for each row in a
 * RowSequence.
 *
 * @author Christian Brechb&uuml;hler (christian@arsdigita.com)
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/Multiple.java#8 $
 * */
public class Multiple extends SimpleContainer
{

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Multiple.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private RequestLocal m_rows;        // a RowSequence
    private RowSequenceBuilder m_builder = null;

    public Multiple (RowSequenceBuilder builder) {
        m_rows = new RequestLocal();
        m_builder = builder;
    }

    /**
     * Obtains a column from the current row.
     * @param state for getting the (RequestLocal) RowSequence.
     * @param name the column to return
     * @return the named column.
     */
    public Object getColumn(PageState state, String name) {
        return ((DataQuery)m_rows.get(state)).get(name);
    }

    /**
     * Returns the current position within the sequence. The first
     * position is 0.
     *
     * @return the current position; -1 if there is no current position.
     **/
    int getPosition(PageState state) {
        return ((DataQuery)m_rows.get(state)).getPosition() - 1;
    }

    /**
     * Adds child components repeatedly under parent node.
     */
    public void generateXML(PageState state, Element p) {
        if ( ! isVisible(state) ) {
            return;
        }

        Element parent = generateParent(p);

        DataQuery rows = m_builder.makeRowSequence(state);
        m_rows.set(state, rows);        // give nested Components access

        while (rows.next()) {
            // generate XML for children
            for (Iterator i = children(); i.hasNext(); ) {
                Component c = (Component) i.next();
                c.generateXML(state, parent);
            }
        }
    }
}
