/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import javax.servlet.ServletException;

/**
 * This class represents exceptions that occur within the processing
 * methods of any of the form event listeners.  Typically the code
 * will catch specific exceptions such as <code>SQLException</code>
 * and rethrow them as instances of this class to pass the message to
 * the controller in a standard fashion.
 *
 * <p>Since this class is a subclass of <code>ServletException</code>,
 * servlets that do form processing within a <code>doPost</code> or
 * <code>doGet</code> methods do not need to explicitly catch
 * instances of this class.  However, they may wish to do so for
 * special error reporting to the user, or to notify the webmaster via
 * e-mail of the problem. */

public class FormProcessException extends ServletException {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/FormProcessException.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FormProcessException(String message) {
        super(message);
    }

    public FormProcessException(String message, Throwable rootCause) {
        super(message, rootCause);
    }

    public FormProcessException(Throwable rootCause) {
        super(rootCause);
    }

    /**
     * In addition to printing the stack trace for this exception, also prints
     * the stack trace for the root cause, if any.  This is a workaround for
     * those implementations of {@link ServletException} that don't implement
     * <code>printStackTrace</code> correctly.  If you happen to use an
     * implementation that does, the stack trace for the root cause may be
     * printed twice, which is not that big of a deal in the grand scheme of
     * things.
     */
    public void printStackTrace() {
        super.printStackTrace();
        if (getRootCause() != null) {
            System.err.print("Root cause: ");
            getRootCause().printStackTrace();
        }
    }

    /**
     * @see #printStackTrace()
     */
    public void printStackTrace(java.io.PrintStream s) {
        super.printStackTrace(s);
        if (getRootCause() != null) {
            s.println("Root cause: ");
            getRootCause().printStackTrace(s);
        }
    }

    /**
     * @see #printStackTrace()       
     */
    public void printStackTrace(java.io.PrintWriter s) {
        super.printStackTrace(s);
        if (getRootCause() != null) {
            s.println("Root cause: ");
            getRootCause().printStackTrace(s);
        }
    }

    /**
     * <p>Returns the concatenation of {@link #getMessage()} and {@link
     * #getRootCause()}.<code>getMessage()</code>.</p>
     **/
    public String getMessages() {
        StringBuffer result = new StringBuffer(getMessage());
        if ( getRootCause() != null ) {
            result.append(" (root cause: ")
                .append(getRootCause().getMessage())
                .append(")");
        }
        return result.toString();
    }
}
