/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.event.PrintListener;

/**
 * A link to an external (non-ACS) site.  Does not propagate ACS-specific
 * URL parameters.
 *
 * <p>See {@link BaseLink} for a description
 * of all Bebop Link classes.
 **/
public class ExternalLink extends Link {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ExternalLink.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public ExternalLink(Component child, String url) {
        super(child, url);
    }

    public ExternalLink(Component child, PrintListener l) {
        super(child, l);
    }

    public ExternalLink(String label, String url) {
        super(label, url);
    }

    public ExternalLink(String label, PrintListener l) {
        super(label, l);
    }

    public ExternalLink(PrintListener l) {
        super(l);
    }
    /**
     * Processes the URL for this link after the print listener runs.
     *
     * @param state the current page state
     * @param url the original URL
     *
     * @return the original, unchanged URL.
     **/
    protected String prepareURL(PageState state, String url) {
        return url;
    }
}
