/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.util.Assert;

import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.developersupport.StackTraces;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.log4j.Logger;

/**
 * Completable
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 **/

public abstract class Completable implements Component {
    private final static Logger s_log = Logger.getLogger(Completable.class);

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Completable.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Completable() {
        if ( s_log.isDebugEnabled() ) {
            StackTraces.captureStackTrace(this);
        }
    }

    private ArrayList m_completionListeners = new ArrayList();

    public void addCompletionListener(ActionListener listener) {
        Assert.assertNotLocked(this);
        m_completionListeners.add(listener);
    }

    protected void fireCompletionEvent(PageState ps) {
        ActionEvent evt = new ActionEvent(this, ps);
        for (Iterator it = m_completionListeners.iterator(); it.hasNext(); ) {
            ActionListener listener = (ActionListener) it.next();
            listener.actionPerformed(evt);
        }
    }
}
