/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.xml.Element;

/**
 * 
 * A column in a {@link Multiple}.  Outputs the value of the indicated column.
 *
 * @author Christian Brechb&uuml;hler (christian@arsdigita.com)
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/Column.java#9 $
 * */
public class Column extends SimpleComponent  {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Column.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Multiple m_parent;          // parent holding RowSequence
    private String m_name;          // name of the column to output

    /* Create a column.
     * @param parent indicates in to which {@link Multiple} this
     * column belongs.  This is indication is necessary when Multiples
     * nest.  In the page structure, the indicated parent should
     * become an ancestor.
     * @param name the column to be output.  */
    public Column (Multiple parent, String name) {
        m_parent = parent;
        m_name   = name;
    }

    /**
     * Adds the value of the column as a <code>&lt;bebop:cell&gt;</code>.
     */
    public void generateXML(PageState state, Element parent) {
        if ( isVisible(state) ) {
            Element item  = parent.newChildElement("bebop:cell", BEBOP_XML_NS);
            item.setText(m_parent.getColumn(state, m_name).toString());
        }
    }
}
