/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.page.PageTransformer;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.ui.SimplePage;
import com.arsdigita.util.parameter.ClassParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.SingletonParameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.util.parameter.BooleanParameter;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross
 * @see com.arsdigita.bebop.Bebop
 */
public final class BebopConfig extends AbstractConfig {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/bebop/BebopConfig.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(BebopConfig.class);

    private final Parameter m_presenter;
    private final Parameter m_page;
    private final Parameter m_tidy;
    private final Parameter m_fancyErrors;

    public BebopConfig() {
        m_presenter = new SingletonParameter
            ("waf.bebop.presentation_manager", Parameter.REQUIRED,
             new PageTransformer());

        m_page = new ClassParameter
            ("waf.bebop.base_page", Parameter.REQUIRED, SimplePage.class);

        m_tidy = new StringParameter
            ("waf.bebop.tidy_config_file", Parameter.REQUIRED,
             "com/arsdigita/bebop/parameters/tidy.properties");

        m_fancyErrors = new BooleanParameter
            ("waf.bebop.fancy_xsl_errors",
             Parameter.REQUIRED,
             Boolean.FALSE);

        register(m_presenter);
        register(m_page);
        register(m_tidy);
        register(m_fancyErrors);

        loadInfo();
    }

    /**
     * Gets the configured <code>PresentationManger</code>.
     */
    public final PresentationManager getPresentationManager() {
        return (PresentationManager) get(m_presenter);
    }

    final Class getBasePageClass() {
        return (Class) get(m_page);
    }

    /**
     * I don't *want* to make this public. XXX
     */
    public final String getTidyConfigFile() {
        return (String) get(m_tidy);
    }
    
    public boolean wantFancyXSLErrors() {
        return ((Boolean)get(m_fancyErrors)).booleanValue();
    }
}
