/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import org.jdom.JDOMException;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLException extends JDOMException {
    public XMLException() {
        super();
    }

    public XMLException(String s) {
        super(s);
    }

    public XMLException(String s, Throwable throwable) {
        super(s, throwable);
    }

    public XMLException(String s, Element e) {
        super(makeMessage(s, e));
    }

    public XMLException(String s, Throwable throwable, Element e) {
        super(makeMessage(s,e), throwable);
    }

    private static String makeMessage(String msg, Element e) {
        XMLOutputter out = new XMLOutputter();
        final String elementText = out.outputString(e);
        final String newMessage  = msg + System.getProperty("line.separator") + elementText;
        return newMessage;
    }

}
