/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.xmlutil;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.DocType;
import org.jdom.input.JDOMFactory;

/**
 * Document subtype for XML tests. Right now, only used to store a reference to the JDOMFactory
 * used to construct the document. This allows child elements with import instructions to access the
 * correct JDOMFactory to build child documents.
 */
public class TestDocument extends Document {
    public TestDocument(Element rootElement, JDOMFactory factory) {
        super(rootElement);
        m_factory = factory;
    }

    public TestDocument(Element rootElement, DocType docType, JDOMFactory factory) {
        super(rootElement, docType);
        m_factory = factory;
    }

    public JDOMFactory getFactory() {
        return m_factory;
    }


    private JDOMFactory m_factory;
}
