/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.kernel.*;
import com.arsdigita.db.Sequences;
import com.arsdigita.util.UncheckedWrapperException;

import java.sql.SQLException;
import java.math.BigDecimal;

/**
 * Created by IntelliJ IDEA.
 * User: jorris
 * Date: Feb 11, 2004
 * Time: 6:23:46 PM
 * To change this template use File | Settings | File Templates.
 */
public class WorkflowTestCase extends BaseTestCase {
    public WorkflowTestCase(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestHelper.setCurrentSystemParty(Kernel.getSystemParty());
        super.tearDown();
    }

    protected User makeNewUser() {
        final String email =  "tristan(" +
                        nextValue() +
                        ")@example.com";

        new KernelExcursion() {
            protected void excurse() {
                setEffectiveParty(Kernel.getSystemParty());
                User user = new User();
                user.setPrimaryEmail( new EmailAddress(email) );
                user.getPersonName().setGivenName( "Mega Toucus" );
                user.getPersonName().setFamilyName( "Jehosophat" );
                user.save();

            }
        }.run();

        UserCollection users = User.retrieveAll();
        users.addEqualsFilter("primaryEmail", email);
        try {
            if(users.next()) {
                return users.getUser();
            }
        } finally {
            users.close();
        }
        throw new IllegalStateException("Couldn't fetch user " + email);
    }

    protected Group makeNewGroup() {
        final BigDecimal groupNum = nextValue();
        final String email = "group(" +
                        groupNum +
                        ")@arsdigita.com";

      new KernelExcursion() {
            protected void excurse() {
                setEffectiveParty(Kernel.getSystemParty());
                Group user = new Group();
                user.setPrimaryEmail( new EmailAddress(email) );
                user.setName("Group_" + groupNum);
                user.save();

            }
        }.run();

        GroupCollection groups = Group.retrieveAll();
        groups.addEqualsFilter("primaryEmail", email);
        try {
            if(groups.next()) {
                return groups.getGroup();
            }
        } finally {
            groups.close();
        }
        throw new IllegalStateException("Couldn't fetch user " + email);

    }

    private BigDecimal nextValue() {
        try {
            return Sequences.getNextValue();
        } catch (SQLException e) {
            throw new UncheckedWrapperException(e.getMessage(), e);
        }
    }
}
