/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.web.Application;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

/*
 * Created by IntelliJ IDEA.
 * User: jorris
 * Date: Oct 20, 2002
 * Time: 8:48:49 PM
 * To change this template use Options | File Templates.
 */
public class TestApplication extends Application {
   public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.web.TestApplication";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public TestApplication(DataObject dataObject) {
        super(dataObject);
    }

    public TestApplication(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public String getServletPath() {
        return URL.SERVLET_DIR + "/testapp";
    }

    public static TestApplication createTestApp(String title) {
        final TestApplication app = (TestApplication) 
            Application.createApplication
                (BASE_DATA_OBJECT_TYPE, "testapp", title, null);
       
        app.save();
       
        return app;
    }
}
