/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.*;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.DummyServletConfig;
import com.arsdigita.util.UncheckedWrapperException;
import org.apache.log4j.Logger;

import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Tests Application dispatching
 *
 */
public class ApplicationDispatchTest extends WebTestCase {
   public ApplicationDispatchTest(String name) {
      super(name);
   }

   private static Logger s_log = Logger.getLogger(ApplicationDispatchTest.class);
   private TestApplication m_app;
   private BaseApplicationServlet m_appServlet;

   protected void setUp() throws Exception {
      super.setUp();

      setupApplication();

      m_app = TestApplication.createTestApp("TestApplication");

      setupApplicationServlet();
   }

   private void setupApplicationServlet() throws ServletException {
      m_appServlet = new BaseApplicationServlet() {
         protected void doService(HttpServletRequest sreq,
                                  HttpServletResponse sresp,
                                  Application app)
               throws ServletException, IOException {

            s_log.info("Dispatching to application!");
         }

         protected UserContext getUserContext(HttpServletRequest sreq,
                                    HttpServletResponse sresp) {
            UserContext ctx =  super.getUserContext(sreq, sresp);
/*
            try {
                User user = new User() {
                    public EmailAddress getPrimaryEmail() {
                        EmailAddress address = Kernel.getSystemParty().getPrimaryEmail();
                        return address;
                    }
                };
                ctx.login(user);
            } catch (LoginException e) {
               throw new UncheckedWrapperException("Login failure", e);
            }
            */
            return ctx;
         }
      };
      ServletConfig config = new DummyServletConfig("TestApplicationServlet");
      m_appServlet.init(config);

      this.m_container.addServletMapping(m_app.getServletPath(), m_appServlet);
   }

   static void setupApplication() {
      ApplicationSetup setup = new ApplicationSetup(s_log);

      setup.setApplicationObjectType(TestApplication.BASE_DATA_OBJECT_TYPE);
      setup.setTitle("TestApplication");
      setup.setDescription
            ("This is a test application.");
      setup.setKey("testapp");
      setup.setDispatcherClass("com.arsdigita.is.this.really.Needed");
      setup.setStylesheet("/packages/webtest/xsl/test.xsl");

      setup.setInstantiator(new ACSObjectInstantiator() {
         public DomainObject doNewInstance(DataObject dataObject) {
            return new TestApplication(dataObject);
         }
      });

      setup.run();
   }

   public void testApplicationCache() throws Exception {
      m_container.getRequest().getServletURL().setPathInfo("/testapp/");
      m_container.dispatch(m_dispatcher);
   }

}
