/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.test;

import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.util.UncheckedWrapperException;
import com.meterware.httpunit.*;

import java.io.IOException;

import org.xml.sax.SAXException;

/**
 * Class CoreHttpUnit
 * 
 * @author jorris@redhat.com
 * @version $Revision $1 $ $Date: 2004/04/07 $
 */
public class CoreHttpUnit {
    private final String m_swaEmail;
    private final String m_swaPasswd;
    private final String m_rootURL;
    private final WebConversation m_wc  = new WebConversation();

    public CoreHttpUnit(final String swaEmail,
                        final String swaPasswd,
                        final String rootURL) {
        m_swaEmail = swaEmail;
        m_swaPasswd = swaPasswd;
        m_rootURL = rootURL;
    }

    public String getRootURL() {
        return m_rootURL;
    }

    public String getSwaEmail() {
        return m_swaEmail;
    }

    public void loginSWA() throws HttpUnitException {
        login(m_swaEmail, m_swaPasswd);
    }

    public void login(final String email, final String password) throws HttpUnitException {
        WebRequest     req = new GetMethodWebRequest( m_rootURL + "/register" );
        try {
            WebResponse   resp = m_wc.getResponse( req );
            WebForm login = resp.getFormWithName("user-login");
            login.setParameter("email", email);
            login.setParameter("password", password);
            login.submit();
        } catch (IOException e) {
            throw new HttpUnitException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new HttpUnitException(e.getMessage(), e);
        }

    }

    public WebResponse gotoURL(final String urlPart) {
        final WebRequest     req = new GetMethodWebRequest( m_rootURL + urlPart );
        return getResponse( req );
    }

    public void createUser(final String firstName,
                           final String lastName,
                           final String password,
                           final String email,
                           final String screenName) {

        final WebRequest     req = new GetMethodWebRequest( m_rootURL + "/admin" );
        getResponse( req );
        clickLink("Create new user");
        final WebForm form = getFormWithName("user-add-form");


        form.setParameter("firstname", firstName);
        form.setParameter("lastname", lastName);
        form.setParameter("password", password);
        form.setParameter("password_confirmation", password);
        form.setParameter("question", password);
        form.setParameter("answer", password);
        form.setParameter("email", email);
        form.setParameter("screenname", screenName);
        submitForm(form);

    }


    public WebResponse clickLink(final String linkText) {
        WebResponse resp = m_wc.getCurrentPage();
        WebLink link;
        try {
            link = resp.getLinkWith(linkText);
        } catch (SAXException e) {
            throw new HttpUnitException("SAX error getting link: " +
                    linkText + " Message: " +
                    e.getMessage(), e);
        }
        if (link == null) {
            throw new NoSuchLinkException(linkText, resp);
        }
        try {
            resp = link.click();
        } catch (IOException e) {
            throw new UncheckedWrapperException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new UncheckedWrapperException(e.getMessage(), e);
        }
        return resp;
    }

    public WebResponse getCurrentPage() {
        WebResponse resp = m_wc.getCurrentPage();
        return resp;
    }

    public WebResponse getResponse(final WebRequest req) {
        try {
            final WebResponse resp = m_wc.getResponse( req );
            return resp;
        } catch (IOException e) {
            throw new HttpUnitException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new HttpUnitException(e.getMessage(), e);
        }
    }

    public WebForm getFormWithName(final String formName) {
        final WebResponse resp = m_wc.getCurrentPage();
        try {
            return resp.getFormWithName(formName);
        } catch (SAXException e) {
            throw new HttpUnitException(e.getMessage(), e);
        }
    }

    public WebResponse submitForm(final WebForm form) {
        try {
            return form.submit();
        } catch (IOException e) {
            throw new HttpUnitException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new HttpUnitException(e.getMessage(), e);
        }
    }

    public WebResponse submitForm(final WebForm form, final String buttonName) {
        try {
            final SubmitButton button = form.getSubmitButton(buttonName);
            return form.submit(button);
        } catch (IOException e) {
            throw new HttpUnitException(e.getMessage(), e);
        } catch (SAXException e) {
            throw new HttpUnitException(e.getMessage(), e);
        }
    }

}
