/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.lucene;

import com.arsdigita.domain.*;
import com.arsdigita.kernel.*;
import com.arsdigita.persistence.*;
import com.arsdigita.search.*;
import java.math.*;

/**
 * Note
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #3 $ $Date: 2004/04/07 $
 **/

class Note extends ACSObject {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/lucene/Note.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.lucene.Note";

    public Note(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public Note() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public String getName() {
        return (String) get("name");
    }

    public void setName(String name) {
        set("name", name);
    }

    public String getText() {
        return (String) get("text");
    }

    public void setText(String text) {
        set("text", text);
    }

    static Adapter adapter() {
        return new StandardAdapter(BASE_DATA_OBJECT_TYPE,
                                   "id",
                                   "name",
                                   null,
                                   new String[] {"text"});
    }

}
