/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;

import java.math.BigDecimal;

/**
 * SearchTestChapter class.  Used to test SearchTestHelp class
 * (gathering content to index for related objects).
 *
 * @author Jeff Teeters
 **/
public class SearchTestChapter extends ACSObject {
    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/intermedia/SearchTestChapter.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.search.intermedia.SearchTestChapter";

    // Authors associated with this chapter
    DataAssociation m_authors = null;


    public SearchTestChapter() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SearchTestChapter(String typeName) {
        super(typeName);
    }

    public SearchTestChapter(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SearchTestChapter(int key)  throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, key));
    }

    public SearchTestChapter(DataObject chapterData) {
        super(chapterData);
    }


    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getDisplayName() {
        return "SearchTestChapter-DisplayName";
    }

    /* Register instantiator with DomainObjectFactory, must be called by
       initializer */
    public static void setupDomainObjectFactory() {
        DomainObjectInstantiator instantiator;

        instantiator = new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new SearchTestChapter(dataObject);
                }
            };
        DomainObjectFactory.registerInstantiator(
                                                 SearchTestChapter.BASE_DATA_OBJECT_TYPE,
                                                 instantiator);
    }

    public void addAuthor(SearchTestAuthor author) {
        if (m_authors == null) {
            m_authors = (DataAssociation) get("authors");
        }
        author.addToAssociation(m_authors);
    }

    public void removeAuthor(SearchTestAuthor author) {
        if (m_authors == null) {
            m_authors = (DataAssociation) get("authors");
        }
        author.removeFromAssociation(m_authors);
    }


    public Integer getChapterNum() {
        return (Integer) get("chapterNum");
    }

    public void setChapterNum(Integer num) {
        set("chapterNum", num);
    }

    public SearchTestBook getBook() {
        DataObject book = (DataObject) get("book");
        if (book == null) {
            return null;
        } else {
            return (SearchTestBook) DomainObjectFactory.newInstance(book);
        }
    }

    public void setBook(SearchTestBook book) {
        setAssociation("book", book);
    }

    public String getContent() {
        return  (String)get("content");
    }

    public void setContent(String content) {
        set("content", content);
    }
}
