/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.tools.junit.extensions.BaseTestSetup;
import com.arsdigita.tools.junit.extensions.CoreTestSetup;
import com.arsdigita.tools.junit.framework.PackageTestSuite;
import junit.framework.Test;

/**
 * SearchSuite
 *
 * @author Daniel Berrange
 * @version $Revision: #15 $ $Date: 2004/04/07 $
 **/

public class SearchSuite extends PackageTestSuite {

    public final static String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/search/SearchSuite.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static class TestIndexerType extends IndexerType {
        TestIndexerType() {
            super("test",
                  new ContentType[] {ContentType.TEXT},
                  new TestDocumentObserver());
        }
    }
    public static final IndexerType TEST_INDEXER = new TestIndexerType();
    
    public SearchSuite() {}

    public SearchSuite(Class theClass) {
        super(theClass);
    }

    public SearchSuite(String name) {
        super(name);
    }

    public static Test suite() {
        SearchSuite suite = new SearchSuite();
        populateSuite(suite);
        BaseTestSetup wrapper = new CoreTestSetup(suite);
        wrapper.addSQLSetupScript("/com/arsdigita/search/setup.sql");
        wrapper.addSQLTeardownScript("/com/arsdigita/search/teardown.sql");
        return wrapper;
    }

    public static void main(String[] args) throws Exception {
        junit.textui.TestRunner.run(suite());
    }

}
