/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.notification;


import java.util.*;

// ACS Core
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.OID;

import com.arsdigita.domain.DataObjectNotFoundException;

// JUnit classes
import com.arsdigita.tools.junit.framework.BaseTestCase;



/**
 * Test of RequestManager
 *
 * @author Stefan Deusch
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/notification/RequestManagerTest.java#7 $
 */
public class RequestManagerTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/notification/RequestManagerTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    static ManagerDispatcher requestMgr;

    protected void setUp() {
        requestMgr  = new ManagerDispatcher(new RequestManager());
    }

    protected void tearDown() {
        requestMgr.interrupt();
    }


    public RequestManagerTest (String name) {
        super(name);
    }

    /**
     * test if Request Manager processes requests correctly
     * only persistent objects can be processed, therefore we
     * use external Transaction context in NotificationSuite.
     *
     */
    public void testRequestManager001() {
        Session session = SessionManager.getSession();

        Notification n = NotificationSuite.getNotification();
        // transaction context is resurrected in getNotification above
        assertEquals("Newly created notification not in PENDING status",
                     Notification.PENDING, n.getStatus());
        OID id = n.getOID();
        session.getTransactionContext().commitTxn();

        // create new RequestManager via ManagerDispatcher and run it
        NotificationSuite.runManager(requestMgr);

        try {
            session.getTransactionContext().beginTxn();
            n = new Notification(id);

            assertEquals("Newly created notification not in QUEUED status",
                         Notification.QUEUED, n.getStatus());

            session.getTransactionContext().commitTxn();

            // test for SENT status is in SimpleQueueManagerTest

        } catch(DataObjectNotFoundException e) {
            // ignore
        }

    }




    /**
     * Main method required to make this test runnable.
     */
    public static void main (String args[]) {
        junit.textui.TestRunner.run(RequestManagerTest.class);
    }
}
