/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.messaging;

// ACS core
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;

// JUnit classes
import com.arsdigita.tools.junit.framework.BaseTestCase;

/**
 * Base test case for Messaging.  Provides some common utilities and
 * setUp() / tearDown() methods for Messaging tests.
 *
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/messaging/MessageTestCase.java#7 $
 */

public class MessageTestCase extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/messaging/MessageTestCase.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * All tests need a Party to represent the Message sender.
     */

    protected Party from;

    public MessageTestCase (String name) {
        super(name);
    }

    protected void setUp() {

        try {
            super.setUp();
        } catch (Exception e) {
            fail(e.getMessage());
        }

        from = getRandomUser();
    }

    /**
     * Private method to generate a random user for testing
     */

    private User getRandomUser() {

        String key   = String.valueOf(System.currentTimeMillis());
        String email = key + "-message-test@arsdigita.com";
        String first = key + "-message-test-given-name";
        String last  = key + "-message-test-family-name";

        User user = new User();
        user.setPrimaryEmail(new EmailAddress(email));

        PersonName name = user.getPersonName();
        name.setGivenName(first);
        name.setFamilyName(last);

        user.save();

        return user;
    }


    /**
     * A utility for debugging.
     */

    public void printMessage (Message msg) {
        try {
            System.out.println("");
            System.out.println("From: ");
            System.out.println("Subject: " + msg.getSubject());
            System.out.println("Sent-Date: " + msg.getSentDate());
            System.out.println("Message-Type: " + msg.getBodyType());
            System.out.println("Message-ID: " + msg.getID());
            System.out.println(msg.getBody());
        } catch (Exception e) {
            fail(e.getMessage());
        }
    }

    /**
     * A single trivial test case.
     */

    public void testMessageCreate001() {
        Message msg = new Message();
    }

    /**
     * Main method required to make this test runnable.
     */

    public static void main (String args[]) {
        junit.textui.TestRunner.run(MessageTestCase.class);
    }
}
