/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.messaging;

// Java core classes
import java.net.URL;
import javax.activation.*;

/**
 * Test cases for MessageParts.
 *
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/messaging/MessagePartTest.java#8 $
 */

public class MessagePartTest extends MessageTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/messaging/MessagePartTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static String name = "attachment";
    private static String desc = "an attached message";
    private static String text = "text body";
    private static String html = "<html><body>html body</body></html>";


    private static String imageURL =
        "http://www.arsdigita.com/graphics/images-Jan-2001/logotag.gif";
    private static String imageType = "image/gif";

    public MessagePartTest (String name) {
        super(name);
    }

    /**
     * Try setting text/plain content
     */

    public void testMessagePart001 () {
        try {
            String type = MessagePart.TEXT_PLAIN;

            MessagePart part = new MessagePart(name,desc);
            part.setText(text);

            assertEquals(name, part.getName());
            assertEquals(text, part.getContent());
            assertEquals(type, part.getContentType());

        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    /**
     * Try setting text/html content
     */

    public void testMessagePart002 () {
        try {
            String type = MessagePart.TEXT_HTML;

            MessagePart part = new MessagePart(name,desc);
            part.setContent(html, type);

            assertEquals(name, part.getName());
            assertEquals(html, part.getContent());
            assertEquals(type, part.getContentType());

        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    /**
     * Try setting the content to an image.
     * This test relies on a now invalid URL. Why it relies on an external URL
     * in the first place....
     */
    public void FAILStestMessagePart003 () {
        try {
            DataHandler dh = new DataHandler(new URL(imageURL));

            MessagePart part = new MessagePart();
            part.setDataHandler(dh);

            assertEquals(part.getName(), dh.getName());
            assertEquals(part.getContentType(), dh.getContentType());

            // Need to add further checks on the actual content being
            // handled, but I don't think this is working correctly
            // inside the persistence layer yet.

            dh = part.getDataHandler();
            assertEquals(dh.getContentType(), imageType);

        } catch (Exception e) {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    /**
     * Main method required to make this test runnable.
     */

    public static void main (String args[]) {
        junit.textui.TestRunner.run(AttachmentTest.class);
    }
}
