/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.persistence.OID;
import com.arsdigita.domain.DataObjectNotFoundException;

/**
 * Regression test for <a href='http://developer.arsdigita.com/acs5/sdm/one-ticket?ticket_id=164566'>bug 164566</a>.
 *
 *
 * @author Rob Mayoff
 * @version 1.0
 * @see com.arsdigita.kernel
 */

public class Bug164566Test extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/kernel/Bug164566Test.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Bug164566Test(String name) {
        super(name);
    }

    public void testBug() throws Exception {
        User u = new User();
        u.setScreenName("testuser");
        u.getPersonName().setGivenName("testuser-givenName");
        u.getPersonName().setFamilyName("testuser-familyName");
        u.setPrimaryEmail(new EmailAddress("testuser@example.com"));
        u.save();

        try {
            SiteNode sn = new SiteNode();
            sn = new SiteNode(new OID(
                                      sn.getBaseDataObjectType(), u.getID()));
            fail("did not get expected DataObjectNotFoundException");
        }

        catch (DataObjectNotFoundException e) {
        }
    }

}
