/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.tools.junit.framework.BaseTestCase;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MixedResourceBundleTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/globalization/MixedResourceBundleTest.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public MixedResourceBundleTest(String name) {
        super(name);
    }

    private int countEnumeration(Enumeration e) {
        int count = 0;
        while (e.hasMoreElements()) {
            count++;
            e.nextElement();
        }
        return count;
    }

    private void verify(ResourceBundle rb,
                        String[][] pairs) throws Exception
    {
        assertEquals("bundle size", pairs.length,
                     countEnumeration(rb.getKeys()));

        for (int i = 0; i < pairs.length; i++) {
            assertEquals("value for " + pairs[i][0],
                         pairs[i][1], rb.getString(pairs[i][0]));
        }
    }

    private ResourceBundle getBundle(String number,
                                     String language, String country)
    {
        return ResourceBundle.getBundle(
                                        "com.arsdigita.globalization.MRBundle" + number,
                                        new Locale(language, country));
    }

    public void test0() throws Exception {
        try {
            getBundle("0", "", "");
            fail("found non-existent MRBundle0");
        } catch (MissingResourceException e) {
        }
    }

    public void test1() throws Exception {
        verify(
               getBundle("1", "", ""),
               new String[][] { }
               );
    }
}
