/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// The class we are testing
import com.arsdigita.formbuilder.PersistentTextArea;

// Interface of the class that we are testing
import com.arsdigita.formbuilder.PersistentComponentFactory;

// Interfaces used by the base test case
import com.arsdigita.bebop.Component;

// For reference
import com.arsdigita.bebop.form.TextArea;

// logging
import org.apache.log4j.Logger;


/**
 * Test the PersistentTextArea class with the test pattern defined in
 * PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentTextAreaTest.java#9 $
 */
public class PersistentTextAreaTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentTextAreaTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(PersistentTextAreaTest.class.getName());

    // Properties of the text area
    private static String m_htmlName = "Test Text Area Name";
    private static int m_nColumns = 30;
    private static int m_nRows = 10;
    private static String m_defaultValue = "Test Text Area Default Value";

    /**
     * JUnit needs this constructor
     */
    public PersistentTextAreaTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentTextArea factory =
            PersistentTextArea.create(m_htmlName);

        factory.setDefaultValue(m_defaultValue);
        factory.setCols(m_nColumns);
        factory.setRows(m_nRows);

        return factory;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {
        TextArea textArea = new TextArea(m_htmlName);

        textArea.setDefaultValue(m_defaultValue);
        textArea.setCols(m_nColumns);
        textArea.setRows(m_nRows);

        return textArea;
    }

    // We do not override the checkPersistenceAttributes() method since we keep
    // no persistence specific attributes for the TextArea
}
