/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.test;


// The class we are testing here
import com.arsdigita.formbuilder.PersistentSingleSelect;

// For adding options
import com.arsdigita.formbuilder.PersistentOption;

// Interfaces used by the component base test case
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.bebop.Component;

// Reference
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Option;

// logging
import org.apache.log4j.Logger;


/**
 * Test the PersistentSingleSelect class with the test pattern defined in
 * the PersistentComponentTestCase.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentSingleSelectTest.java#9 $
 *
 */
public class PersistentSingleSelectTest extends PersistentComponentTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/formbuilder/test/PersistentSingleSelectTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private final static Logger s_log =
        Logger.getLogger(PersistentSingleSelectTest.class.getName());

    // Properties of the select
    private String m_selectName = "select_name";

    // Names and labels for the options
    private String m_name1 = "option_name1";
    private String m_label1 = "Option Label 1";

    private String m_name2 = "option_name2";
    private String m_label2 = "Option Label 2";

    private String m_name3 = "option_name3";
    private String m_label3 = "Option Label 3";

    private String m_name4 = "option_name4";
    private String m_label4 = "Option Label 4";

    /**
     * JUnit needs this constructor
     */
    public PersistentSingleSelectTest(String name) {
        super(name);
    }

    // *** Methods inherited from PersistentComponentTestCase

    /**
     * This method returns an instance of the appropriate factory.
     */
    protected PersistentComponentFactory createPrimaryPersistentFactory() {

        PersistentSingleSelect select = PersistentSingleSelect.create(m_selectName);

        // Create a couple of options
        PersistentOption option1 = PersistentOption.create(m_name1, m_label1);
        PersistentOption option2 = PersistentOption.create(m_name2, m_label2);
        PersistentOption option3 = PersistentOption.create(m_name3, m_label3);
        PersistentOption option4 = PersistentOption.create(m_name4, m_label4);

        // Test adding and removing options
        select.addOption(option1, true);

        select.addOption(option2, 1, true);

        select.addOption(option3);

        select.addOption(option4, 4);

        // Test selecting one of the options
        select.setOptionSelected(option1, false);
        select.setOptionSelected(option2, false);
        select.setOptionSelected(option4, true);

        // Now option 1 and 4 are selected. The order is 2-1-3-4

        return select;
    }

    /**
     * This method creates a new reference component and populates it with
     * test data
     */
    protected Component createPrimaryReferenceComponent() {

        SingleSelect select = new SingleSelect(m_selectName);

        Option option1 = new Option(m_name1, m_label1);
        Option option2 = new Option(m_name2, m_label2);
        Option option3 = new Option(m_name3, m_label3);
        Option option4 = new Option(m_name4, m_label4);


        select.addOption(option2);
        select.addOption(option1);
        select.addOption(option3);
        select.addOption(option4);

        select.setOptionSelected(option4);

        return select;
    }
}
