/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import javax.servlet.*;
import javax.servlet.http.*;
import java.util.*;
import java.net.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.PrintWriter;

import junit.framework.*;

import org.apache.cactus.*;
import org.apache.cactus.util.*;

import org.apache.log4j.Logger;

import com.arsdigita.dispatcher.*;
import com.arsdigita.initializer.*;

public class BaseDispatcherServletCactusTest extends ServletTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/dispatcher/BaseDispatcherServletCactusTest.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    BaseDispatcherServlet s;
    RequestContext rctx;

    boolean startFired;
    boolean finishFired;

    MultipartHttpServletRequest mp_request;

    final Logger s_cat =
        Logger.getLogger(BaseDispatcherServletCactusTest.class.getName());

    public BaseDispatcherServletCactusTest(String theName) {
        super(theName);
    }

    public void setUp() {
        s = new BaseDispatcherServlet() {
                protected RequestContext authenticateUser
                    (HttpServletRequest req,
                     HttpServletResponse resp,
                     RequestContext ctx)
                    throws RedirectException {
                    return ctx;
                }

                public void dispatch(HttpServletRequest req,
                                     HttpServletResponse resp,
                                     RequestContext actx)
                    throws javax.servlet.ServletException, java.io.IOException {
                    try {
                        rctx = actx;

                        if (req instanceof MultipartHttpServletRequest) {
                            mp_request = (MultipartHttpServletRequest) req;
                        }

                        PrintWriter out = resp.getWriter();
                        out.println("<html><head><title>hello</title>" +
                                    "</head><body>hello!</body></html>");

                    } catch (Throwable t){
                        s_cat.error("BaseDispatcherServlet error",t);
                    }
                    return;
                }
            };
    }

    public void beginRequestContext(WebRequest req) {
        ServletURL u = req.getURL();

        req.setURL("localhost","/enterprise",
                   "/foo", "/bar.jsp", null);
    }


    /** Tests creation of request context & validates some
        URL bookkeeping functions.
    */

    public void testRequestContext()
        throws javax.servlet.ServletException, java.io.IOException {

        s_cat.info("BaseDispatcherServletCactusTest.testRequestContext()");

        s.init(config);
        s.service(request, response);
        assertTrue(rctx != null);
        assertTrue(rctx.getOutputType() != null);
        assertEquals(rctx.getRemainingURLPart(),"/foo/bar.jsp");
        assertEquals(rctx.getProcessedURLPart(),"/enterprise");
        assertEquals(rctx.getOriginalURL(),"/enterprise/foo/bar.jsp");

        s_cat.info("All you need is ");
        s_cat.info("BaseDispatcherServletCactusTest Love\n");
        s_cat.info(rctx.getOriginalURL() + ", " + rctx.getRemainingURLPart()
                   + ", " + rctx.getProcessedURLPart() + "\n");
        s_cat.info(request.getRequestURI() + "\n");
    }

    /** Tests registering of an RequestListener and basic event firing
     */

    public void beginRequestListener(WebRequest req) {
        req.setURL("localhost","/enterprise",
                   "/foo", "/bar.jsp", null);
    }

    public void testRequestListener()
        throws javax.servlet.ServletException, java.io.IOException {

        startFired = false;
        finishFired = false;

        RequestListener rl = new RequestListener() {
                public void requestStarted(RequestEvent e) {
                    startFired = true;
                }

                public void requestFinished(RequestEvent e) {
                    finishFired = true;
                }
            };

        s.addRequestListener(rl);
        s.init(config);
        s.service(request,response);

        assertTrue(startFired);
        assertTrue(finishFired);
    }



    public void beginMultipartRequestFails(WebRequest req) {
        req.setURL("localhost","/enterprise",
                   "/somePackage", "/someAdditionalPath", null);
        req.addHeader("Content-type","multipart/form-data");
        req.addParameter("foo","bar",WebRequest.POST_METHOD);
        req.addParameter("baz","qux",WebRequest.POST_METHOD);
    }

    /** Tests creation of a MultipartRequest.

    This'll fail until we get cactus support for
    multipart/form-data requests.

    */

    public void dontTestMultipartRequest()
        throws javax.servlet.ServletException, java.io.IOException {
        s.init(config);
        s.service(request, response);
        assertNotNull(mp_request);
    }

}
