/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.kernel.Group;

import java.util.Collection;

import org.apache.log4j.Logger;

/**
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2004-01-23
 * @version $Revision: #4 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategorizedObjectTest extends CategoryTestCase {

    private final static Logger s_log = Logger.getLogger(CategorizedObjectTest.class);

    Category cat1;
    Category cat2;
    private Group group;

    public CategorizedObjectTest( String name ) {
        super( name );
    }

    public void setUp() {
        cat1 = new Category();
        cat1.setName("child");
        cat2 = new Category();
        cat2.setName("parent");
        group = new Group();
        group.setName("group");
    }

    public void testGetParentCategories() {
        cat2.addChild(cat1);
        cat1.addChild(group);
        CategorizedObject catObj = new CategorizedObject(group);
        Collection parents = catObj.getParentCategories();
        assertEquals("single parent", 1, parents.size());
        assertTrue("cat1 is the only parent", parents.contains(cat1));
    }

    public void testGetParents() {
        cat2.addChild(cat1);
        cat1.addChild(group);
        CategorizedObject catObj = new CategorizedObject(group);

        assertSize(catObj.getParents(), 1);
        assertContains(catObj.getParents(), cat1);
    }
}
