/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.*;
import com.arsdigita.tools.junit.framework.BaseTestCase;
import com.arsdigita.util.HttpServletDummyRequest;

import java.lang.IllegalArgumentException;


public class IntegerParameterTest extends BaseTestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/parameters/IntegerParameterTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
       Constructs a test with the specified name.

       @param name Name of the test
    */
    protected ParameterModel _stringParameter;
    protected ParameterModel _integerParameter;
    protected HttpServletDummyRequest _httpRequest;

    public IntegerParameterTest(String id) {
        super(id);
    }

    /**
       Sets up the test fixture.
    */
    protected void setUp() {
        _stringParameter =  new StringParameter("StringParameter");
        _integerParameter =  new IntegerParameter("IntegerParameter");
        _httpRequest = new HttpServletDummyRequest();
    }

    /**
       Tears down the text fixture.
       Called after every test case method.
    */
    protected void tearDown() {
        _stringParameter=null;
        _integerParameter=null;
        _httpRequest=null;
    }

    public void testIntegerParameterNoValues() {

        String[] specifiedValues = {};
        _httpRequest.setParameterValues("IntegerParameter",specifiedValues );
        assertEquals(_integerParameter.transformValue(_httpRequest),null);
    }

    public void testIntegerParameterBadValue() {

        String[] specifiedValues = {"Not an Integer"};
        _httpRequest.setParameterValues("IntegerParameter",specifiedValues );
        try {
            Integer temp = (Integer)_integerParameter.transformValue(_httpRequest);
            // if you get here an exception was not raised
            fail("an IllegalArgumentException should have been raised");
        } catch (IllegalArgumentException iae) {
            // ok
        }
    }

    public void testIntegerParameterSomeBadValue() {
        String[] specifiedValues = {"5","Not an Integer"};
        _httpRequest.setParameterValues("IntegerParameter",specifiedValues );
        assertEquals(_integerParameter.transformValue(_httpRequest),new Integer("5"));
    }

    public void testIntegerParameterGoodIntegerValue() {
        String[] specifiedValues = {"5"};
        _httpRequest.setParameterValues("IntegerParameter",specifiedValues );
        assertEquals(_integerParameter.transformValue(_httpRequest),new Integer("5"));
    }
    /*
      move this test to NumberArryTest.java

      public void testIntegerParameterBadIntegerValue() {
      String[] specifiedValues = {"5.01"};
      _httpRequest.setParameterValues("IntegerParameter",specifiedValues );

      try {
      Object[] temp = _integerParameter.transformValues(_httpRequest);
      // if you get here an exception was not raised
      assert(false);
      } catch (IllegalArgumentException iae) {
      assert(true);
      }
      }

      public void testIntegerParameterSomeBadValues() {
      String[] specifiedValues = {"5", "Not an Integer"};
      _httpRequest.setParameterValues("IntegerParameter",specifiedValues );
      try {
      Object[] temp = _integerParameter.transformValues(_httpRequest);
      //if you get here an exception was not raised
      assert(false);
      } catch (IllegalArgumentException iae) {
      assert(true);
      }
      }

      public void testIntegerParameterSomeBadIntegerValues() {
      String[] specifiedValues = {"5","4.05"};
      _httpRequest.setParameterValues("IntegerParameter",specifiedValues );

      try {
      Object[] temp = _integerParameter.transformValues(_httpRequest);
      // if you get here an exception was not raised
      assert(false);
      } catch (IllegalArgumentException iae) {
      assert(true);
      }
      }
    */


}
