/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

// Test Related
import com.meterware.httpunit.*;
import com.arsdigita.test.HttpUnitTestCase;
import junit.framework.*;

// for regular expression matching
import org.apache.oro.text.perl.Perl5Util;

/**
 * Affirmative-validation test to make sure that /bebop-demo
 * is set up and works as advertised.   May break if stylesheets
 * are changed.
 *
 *
 * @author Bill Schneider
 * @version 1.0
 *
 */

public class RedirectRaceTest extends HttpUnitTestCase {

    public RedirectRaceTest(String name) {
        super(name);
    }

    public void testRace() throws Exception {
        String random = Long.toString(System.currentTimeMillis() % 1000);
        WebResponse resp = getResponse("/bebop-jsp/redirect-race-1.jsp?random="
                                       + random);
        // now we have the response
        assertTrue(resp.getText().indexOf(random) >= 0);
    }

}
