/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import junit.framework.TestCase;

import com.arsdigita.xml.*;
import java.util.Iterator;

import com.arsdigita.bebop.parameters.StringParameter;

/**
 * Regression tests for Page.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class PageTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/PageTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    SimpleComponent m_comp;
    Page m_page;
    PageState m_ps;

    public PageTest (String id) throws javax.servlet.ServletException {
        super(id);
    }

    public void setUp() {
        m_page = new Page();
        m_comp = new SimpleComponent();
        // m_ps = new PageState(m_page, new HttpServletDummyRequest(), new HttpServletDummyResponse());
    }

    public void tearDown() {
        m_page = null;
        m_comp = null;
        m_ps = null;
    }

    public void testMangling() {
        String name = "name";
        StringParameter p = new StringParameter(name);
        m_page.addComponent(m_comp);
        m_page.addComponentStateParam(m_comp, p);
        assertTrue(! name.equals(p.getName()));
        m_page.addGlobalStateParam(p);
        assertEquals(name, p.getName());
    }

}
