/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import junit.framework.TestCase;

import com.arsdigita.xml.*;
import java.util.Iterator;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;

/**
 * Regression tests for the Component interface.
 *
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */

public class ComponentTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/ComponentTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    ComponentImpl m_ComponentImpl;
    Page m_page;
    PageState m_ps;

    public static final boolean FAILS = true;

    public ComponentTest (String id) throws javax.servlet.ServletException {
        super(id);

        m_ComponentImpl = new ComponentImpl();
        m_page = new Page();
        m_ps = new PageState(m_page, new HttpServletDummyRequest(), new HttpServletDummyResponse());
    }

    public void testGenerateXML() {
        Element e = new Element("foo");
        m_ComponentImpl.lock();
        m_ComponentImpl.generateXML(m_ps,e);
    }

    public void testRespond() throws javax.servlet.ServletException {
        m_ComponentImpl.respond(m_ps);
    }

    public void testChildren() {
        Iterator i = m_ComponentImpl.children();
    }

}
