/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web.monitoring;

import com.arsdigita.db.ConnectionManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 * This page checks to make sure that the database is still working
 * properly.  If it is, the page contains the word "success".  If it
 * is not then it returned the word "failed".
 *
 * To use this, simply map it to a URL in one of your dispatchers.
 * You can then point the correct keepalive script to point at the page
 * and look at the output
 *
 * @author Randy Graebner (randyg@alum.mit.edu)
 * @version $Revision: #6 $, $Date: 2004/04/07 $
 */
public class DBTestServlet extends HttpServlet {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/monitoring/DBTestServlet.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(DBTestServlet.class);

    private Date m_date = new Date();

    public final void service(final HttpServletRequest sreq,
                              final HttpServletResponse sresp)
        throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.debug("Servicing request " + sreq.getRequestURI() + " [" +
                        sreq.getContextPath() + "," +
                        sreq.getServletPath() + "," +
                        sreq.getPathInfo() + "," +
                        sreq.getQueryString() + "]");
        }

        PrintWriter out = sresp.getWriter();
        m_date.setTime(System.currentTimeMillis());

        Connection conn = null;
        try {
            conn = ConnectionManager.getConnection();

            if ( conn != null ) {
                String query = "select 1 from dual";
                Statement stmt = conn.createStatement();
                ResultSet rset = stmt.executeQuery(query);

                if ( rset.next() ) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("Database test successful");
                    }
                    out.println("success - " + m_date);                    
                    return;
                }                
            } else {
                s_log.warn("Null connection returned during database test");
            }
        } catch (SQLException e) {
            s_log.warn("SQLException during database test", e);
        } finally {
            if (conn != null) {
                try {
                    ConnectionManager.returnConnection(conn);
                } catch (SQLException ex) {
                    s_log.warn("Unable to return connection", ex);
                }
            }
        }

        out.println("failure - " + m_date);
    }
}
