/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.Startup;
import com.arsdigita.util.Assert;
import com.arsdigita.util.jdbc.Connections;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/WebApp.java#5 $
 */
public final class WebApp extends DomainObject {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/WebApp.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(WebApp.class);

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.web.WebApp";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public WebApp(final DataObject data) {
        super(data);
    }

    public final String getName() {
        return (String) get("name");
    }

    public static WebApp create(final String name) {
        Assert.exists(name, String.class);

        final DataObject data = SessionManager.getSession().create
            (new OID(BASE_DATA_OBJECT_TYPE, name));

        return new WebApp(data);
    }

    public static DomainCollection retrieveAll() {
        final DataCollection all = SessionManager.getSession().retrieve
            (BASE_DATA_OBJECT_TYPE);

        return new DomainCollection(all);
    }

    // Informal testing code
    public static final void main(final String[] args) {
	new Startup().run();

        SessionManager.getSession().getTransactionContext().beginTxn();

        if (args.length == 1) {
            WebApp.create(args[0]);
        }

        final DomainCollection webapps = WebApp.retrieveAll();

        while (webapps.next()) {
            final WebApp webapp = (WebApp) webapps.getDomainObject();

            System.out.println(webapp.getName());
        }

        SessionManager.getSession().getTransactionContext().commitTxn();
    }
}
