/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.AbstractScript;
import com.arsdigita.runtime.InteractiveParameterLoader;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.Script;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.runtime.Startup;
import com.arsdigita.util.jdbc.Connections;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterLoader;
import com.arsdigita.util.parameter.StringParameter;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/HostLoader.java#5 $
 */
public final class HostLoader extends AbstractScript {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/HostLoader.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(HostLoader.class);

    private final Parameter m_name;
    private final Parameter m_port;

    public HostLoader() {
        m_name = new StringParameter("name");
        m_port = new IntegerParameter("port");

        register(m_name);
        register(m_port);
    }

    private final String getName() {
        return (String) get(m_name);
    }

    private final int getPort() {
        return ((Integer) get(m_port)).intValue();
    }

    public final void run(final ScriptContext context) {
	Host.create(getName(), getPort());
    }

    public static final void main(final String[] args) {
	new Startup().run();

	final Session session = SessionManager.getSession();
	final ParameterLoader loader = new InteractiveParameterLoader
	    (System.in, System.out);

	final TransactionContext transaction = session.getTransactionContext();
	transaction.beginTxn();

        Script script = new HostLoader();
        script.load(loader, new ErrorList());
        script.run(new ScriptContext(session, loader));

	transaction.commitTxn();
    }

}
