/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.util.Assert;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/**
 * <p>Preserves the <code>g11n.enc</code> parameter.  This is a
 * temporary solution.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/GlobalizationParameterListener.java#6 $
 */
class GlobalizationParameterListener implements ParameterListener {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/GlobalizationParameterListener.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (GlobalizationParameterListener.class);

    public final void run(final HttpServletRequest sreq,
                          final ParameterMap map) {
        final String value = sreq.getParameter
            (Globalization.ENCODING_PARAM_NAME);

        if (value == null) {
            final Locale locale = Kernel.getContext().getLocale();

            Assert.assertNotNull(locale, "Locale locale");

            map.setParameter(Globalization.ENCODING_PARAM_NAME,
                             Globalization.getDefaultCharset(locale));

            //if (s_log.isDebugEnabled()) {
            //    s_log.debug("The parameter was null; I set it to '" +
            //                map.getParameter
            //                    (Globalization.ENCODING_PARAM_NAME) + "'");
            //}
        } else {
            //if (s_log.isDebugEnabled()) {
            //    s_log.debug("The parameter was set to '" + value + "'; " +
            //                "preserving it");
            //}

            map.setParameter(Globalization.ENCODING_PARAM_NAME, value);
        }
    }
}
