/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.kernel.ResourceTypeCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

/**
 * <p>A collection of ApplicationTypes.  This class includes methods
 * to filter and order the results of retrieving application
 * types.</p>
 *
 * @see com.arsdigita.web.ApplicationType
 * @see com.arsdigita.web.ApplicationCollection
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //core-platform/dev/src/com/arsdigita/web/ApplicationTypeCollection.java#4 $
 */
public class ApplicationTypeCollection extends ResourceTypeCollection {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/ApplicationTypeCollection.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ApplicationTypeCollection.class);

    public ApplicationTypeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public void filterToFullPageViewable() {
        m_dataCollection.addEqualsFilter("hasFullPageView", Boolean.TRUE);
    }

    public void filterToWorkspaceApplication() {
        m_dataCollection.addEqualsFilter("isWorkspaceApplication",
                                         Boolean.TRUE);
    }

    public void filterToEmbeddable() {
        m_dataCollection.addEqualsFilter("hasEmbeddedView", Boolean.TRUE);
    }

    public void orderByTitle() {
        m_dataCollection.addOrder("title");
    }

    public DomainObject getDomainObject() {
        return getApplicationType();
    }

    public ApplicationType getApplicationType() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Assert.assertNotNull(dataObject, "dataObject");

        ApplicationType applicationType =
            ApplicationType.retrieveApplicationType(dataObject);

        return applicationType;
    }

    public String getApplicationObjectType() {
        return (String) m_dataCollection.get("objectType");
    }

    public String getTitle() {
        return (String) m_dataCollection.get("title");
    }

    public BigDecimal getID() {
        return (BigDecimal)m_dataCollection.get("id");
    }

}
