/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

// new versioning

/**
 * An enumeration of possible operation types.
 *
 * @see Constants#GENERIC_OPERATION
 * @see Constants#CLOB_OPERATION
 * @see Constants#BLOB_OPERATION
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since  2003-05-20
 * @version $Revision: #4 $ $Id: //core-platform/dev/src/com/arsdigita/versioning/OpType.java#4 $
 **/
final class OpType {
    public final String m_datatype;
    public final Integer m_integerValue;

    OpType(String datatype, int intValue) {
        m_datatype = datatype;
        m_integerValue = new Integer(intValue);
    }

    public String datatype() {
        return m_datatype;
    }

    public Integer integerValue() {
        return m_integerValue;
    }
}
