/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

/**
 * Sets up observers and initializes a few disconnected data objects needed by
 * versioning.
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2003-07-30
 * @version $Revision: #17 $ $Date: 2004/04/07 $
 **/
public class Initializer implements com.arsdigita.initializer.Initializer {
    private Configuration m_conf = new Configuration();
    private static final String DEBUG_ON = "debugInterfaceOn";
    private static boolean s_hasRun = false;

    public Initializer() throws InitializationException {
        m_conf.initParameter(DEBUG_ON,
                             "Enable/disable the versioning servlet.",
                             Boolean.class,
                             Boolean.FALSE);
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void startup() throws InitializationException {
        EventType.initialize();
        Types.initialize();
        s_hasRun = true;
    }

    public void shutdown() {}

    /**
     * This package-scoped method is used for unit tests.
     **/
    static boolean hasRun() {
        return s_hasRun;
    }
}
