/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

// new versioning

/**
 * Shared string constants and such.
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2003-04-22
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/
interface Constants {

    String PDL_MODEL = "com.arsdigita.versioning";

    // Txn attributes
    String MOD_USER     = "modUser";
    String TIMESTAMP    = "timestamp";
    String MODIFYING_IP = "modifyingIP";

    // DataObjectChange attributes
    String CHANGE_DATA_TYPE = PDL_MODEL + ".DataObjectChange";
    String ID               = "id";
    String OBJ_ID           = "oid";
    String OPERATIONS       = "operations";
    String TXN              = "txn";

    // Operation attributes
    String ATTRIBUTE  = "attribute";
    String CHANGESET  = "changeset";
    String EVENT_TYPE = "eventType";
    String JAVACLASS  = "javaclass";
    String VALUE      = "value";
    String SUBTYPE    = "subtype";

    // possible operation subtypes
    OpType GENERIC_OPERATION = new OpType(PDL_MODEL + ".GenericOperation", 1);
    OpType CLOB_OPERATION    = new OpType(PDL_MODEL + ".ClobOperation",    2);
    OpType BLOB_OPERATION    = new OpType(PDL_MODEL + ".BlobOperation",    3);

    String OID_TYPE         = "OID";
    String DATA_OBJECT_TYPE = "DataObject";

    String LINE_SEP = System.getProperty("line.separator");

    // Txn attributes
    String TAG_DATA_TYPE = PDL_MODEL + ".Tag";
    String TAG         = "tag";
    String TAGS        = "tags";
    String TAGGED_OID  = "taggedOID";
    String TAGS_TAG = TAGS + "." + TAG;
    String TAGS_TAGGED_OID = TAGS + "." + TAGGED_OID;

    // stuff used by VersioningEventProcessor and Versions
    String TXN_DATA_TYPE = PDL_MODEL + ".Txn";
}
