/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.sitemap;

import com.arsdigita.web.Application;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.domain.DataObjectNotFoundException;

import org.apache.log4j.Logger;

/**
 * Sitemap administration application. Currently a trivial
 * subclass of com.arsdigita.web.Application
 * @see com.arsdigita.web.Application
 */
public class SiteMap extends Application {
    
    private static final Logger s_log = Logger.getLogger(SiteMap.class);

    public static final String BASE_DATA_OBJECT_TYPE 
        = "com.arsdigita.ui.sitemap.SiteMap";

    public SiteMap(DataObject obj) {
        super(obj);
    }

    public SiteMap(OID oid) 
        throws DataObjectNotFoundException {

        super(oid);
    }    
}
