/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.security.Initializer;

/**
 *
 * Component that Renders the Header of the Permissions Admin pages
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/permissions/PermissionsHeader.java#8 $
 */

class PermissionsHeader extends BoxPanel implements PermissionsConstants {

    private Label m_title;
    private PermissionsPane m_parent;

    /**
     * Constructor
     */

    PermissionsHeader(PermissionsPane parent) {
        m_parent = parent;
        m_title = new Label();
        m_title.addPrintListener(new PrintListener() {
                public void prepare(PrintEvent e) {
                    Label t= (Label) e.getTarget();
                    t.setLabel(PAGE_TITLE.localize() +" " +
                               getObjectName(e));
                }
            });

        // Used to render the object name in the navbar

        Label objectName = new Label();
        objectName.addPrintListener(new PrintListener() {
                public void prepare(PrintEvent e) {
                    Label t= (Label) e.getTarget();
                    t.setLabel(getObjectName(e));
                }
            });

        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.add(new Link(PERSONAL_SITE.localize()+"", 
                            "/" + Initializer.getURL(
                                Initializer.WORKSPACE_PAGE_KEY)));
        navbar.add(new Link(MAIN_SITE.localize()+"", "/"));
        navbar.add(new Link(PERMISSIONS_INDEX.localize()+"", "/permissions/"));
        navbar.add(objectName);
        navbar.setClassAttr("permNavBar");
        add(navbar);
    }

    private String getObjectName(PrintEvent e) {
        PageState s = e.getPageState();
        ACSObject obj = m_parent.getObject(s);
        String objName = obj.getDisplayName() +
            " (ID " + obj.getID()+")";
        return objName;
    }

    /**
     * Returns the object used to render the title of the panel.
     */

    Label getTitle() {
        return m_title;
    }
}
