/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 * A Form that allows to search for objects by name
 *
 * @author Stefan Deusch 
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/permissions/PermissionSearchForm.java#10 $
 */

class PermissionSearchForm extends Form
    implements FormProcessListener,
               PermissionsConstants
{
    private static final String FORM_NAME = "permissionSearch";
    private static final String SEARCH_QUERY_PARAM_NAME = "searchQuery";

    /**
     * Constructor
     */

    public PermissionSearchForm() {
        this(new SimpleContainer());
    }

    /**
     * Constructor
     */

    public PermissionSearchForm(SimpleContainer container) {
        super(FORM_NAME, container);
        setMethod(Form.POST);

        add(new Label(new GlobalizedMessage("permissions.searchForm.label")));
        add(new TextField(SEARCH_QUERY_PARAM_NAME));

        Submit submit = new Submit("submit");
        submit.setButtonLabel(SEARCH_BUTTON);
        add(submit);
        addProcessListener(this);
    }

    /**
     * Sends a redirect to the one-permissions page.
     */

    public void process(FormSectionEvent event) throws FormProcessException {
        final String searchQuery = (String)
            event.getFormData().get(SEARCH_QUERY_PARAM_NAME);

        final ParameterMap params = new ParameterMap();
        params.setParameter(OBJECT_ID, searchQuery);

        final URL url = URL.there(event.getPageState().getRequest(),
                                  "/permissions/one",
                                  params);

        throw new RedirectSignal(url, true);
    }

}
