/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.login;

import com.arsdigita.globalization.GlobalizedMessage;

/**
 * Constants used by Login UI.
 **/
public interface LoginConstants
{
    public final static GlobalizedMessage SUBMIT =
        LoginHelper.getMessage("login.submit");
    public final static GlobalizedMessage PRIMARY_EMAIL =
        LoginHelper.getMessage("login.primaryEmail");
    public final static GlobalizedMessage ADDITIONAL_EMAIL =
        LoginHelper.getMessage("login.additionalEmail");
    public final static GlobalizedMessage SCREEN_NAME =
        LoginHelper.getMessage("login.screenName");
    public final static GlobalizedMessage FIRST_NAME =
        LoginHelper.getMessage("login.firstName");
    public final static GlobalizedMessage LAST_NAME =
        LoginHelper.getMessage("login.lastName");
    public final static GlobalizedMessage PASSWORD =
        LoginHelper.getMessage("login.password", new Object[] {
            new Integer(PasswordValidationListener.MIN_LENGTH) });
    public final static GlobalizedMessage PASSWORD_CONFIRMATION =
        LoginHelper.getMessage("login.passwordConfirm");
    public final static GlobalizedMessage PASSWORD_QUESTION =
        LoginHelper.getMessage("login.passwordQuestion");
    public final static GlobalizedMessage PASSWORD_ANSWER =
        LoginHelper.getMessage("login.passwordAnswer");
    public final static GlobalizedMessage URL =
        LoginHelper.getMessage("login.url");
    public final static GlobalizedMessage BIO =
        LoginHelper.getMessage("login.bio");

    public final static GlobalizedMessage ERROR_DUPLICATE_SN =
        LoginHelper.getMessage("login.error.duplicateScreenName");
    public final static GlobalizedMessage ERROR_DUPLICATE_EMAIL =
        LoginHelper.getMessage("login.error.duplicateEmail");
    public final static GlobalizedMessage ERROR_MISMATCH_PASSWORD =
        LoginHelper.getMessage("login.error.mismatchPassword");
    public final static GlobalizedMessage ERROR_BAD_PASSWORD =
        LoginHelper.getMessage("login.error.badPassword");

    public final static GlobalizedMessage ERROR_LOGIN_FAIL =
        LoginHelper.getMessage("login.error.loginFail");

    public final static GlobalizedMessage ERROR_BAD_ANSWER =
        LoginHelper.getMessage("login.error.badAnswer");
    public final static GlobalizedMessage ERROR_BAD_EMAIL =
        LoginHelper.getMessage("login.error.badEmail");

    public final static String FORM_EMAIL =
        "emailAddress";
    public final static String FORM_SCREEN_NAME =
	"screenName";

    // Should not really be named email. Kept this way due to external tests depending on this value.
    public final static String FORM_LOGIN =
	"email";

    public final static String FORM_ADDITIONAL_EMAIL =
        "additional_email";
    public final static String FORM_FIRST_NAME =
        "firstname";
    public final static String FORM_LAST_NAME =
        "lastname";
    public final static String FORM_PASSWORD =
        "password";
    public final static String FORM_PASSWORD_CONFIRMATION =
        "password_confirmation";
    public final static String FORM_PASSWORD_QUESTION =
        "question";
    public final static String FORM_PASSWORD_ANSWER =
        "answer";
    public final static String FORM_URL =
        "url";
    public final static String FORM_URL_DEFAULT =
        "http://";
    public final static String FORM_BIO =
        "biography";
    public final static String FORM_TIMESTAMP =
        "timestamp";
    public final static String FORM_PERSISTENT_LOGIN_P =
        "persistentCookieP";
    public final static String FORM_PERSISTENT_LOGIN_P_DEFAULT =
        "1";

    public final static int TIMESTAMP_LIFETIME_SECS = 300;
    public static final int MAX_NAME_LEN = 60;
}
