/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.PersonName;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserAuthentication;
import javax.mail.internet.InternetAddress;

/**
 * Form used to add a new user to the system.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/UserAddForm.java#9 $
 */

class UserAddForm extends UserForm
    implements FormProcessListener,
               FormInitListener,
               AdminConstants
{
    private AdminSplitPanel m_adminPanel;

    /**
     * Default constructor.
     */

    public UserAddForm (AdminSplitPanel adminPanel) {
        super(USER_FORM_ADD);
        m_adminPanel = adminPanel;

        addInitListener(this);
        addProcessListener(this);

        // Add validation listeners for required parameters

        m_question.addValidationListener
            (new NotEmptyValidationListener());
        m_answer.addValidationListener
            (new NotEmptyValidationListener());
    }

    /**
     *  Initialize the form
     */

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();

        showSecurityInfo(state);

        USER_FORM_LABEL_ADDITIONAL_EMAIL_LIST.setVisible(state, false);
        m_emailList.setVisible(state, false);
    }

    /**
     * Process the form.
     */

    public void process (FormSectionEvent e)
        throws FormProcessException
    {
        PageState state = e.getPageState();

        User user = new User();

        String email =
            ((InternetAddress) m_primaryEmail.getValue(state)).getAddress();

        user.setPrimaryEmail(new EmailAddress(email));
        user.setScreenName((String) m_screenName.getValue(state));

        PersonName name = user.getPersonName();
        name.setGivenName((String) m_firstName.getValue(state));
        name.setFamilyName((String) m_lastName.getValue(state));

        // Check to see if the value has changed from the
        // default.  If not just leave this set to null.

        String uri = (String) m_url.getValue(state);
        if (!uri.equals(USER_FORM_INPUT_URL_DEFAULT) && !uri.equals("")) {
            user.setURI(uri);
        }

        // Add optional additional email address

        InternetAddress additional =
            (InternetAddress) m_additionalEmail.getValue(state);
        if (additional != null) {
            user.addEmailAddress
                (new EmailAddress(additional.getAddress()));
        }

        // Make new user persistent

        user.save();

        // Save user authentication credentials.

        UserAuthentication auth =
            UserAuthentication.createForUser(user);

        auth.setPassword((String) m_password.getValue(state));
        auth.setPasswordQuestion((String) m_question.getValue(state));
        auth.setPasswordAnswer((String) m_answer.getValue(state));
        auth.save();

        // Switch to browse tab.
        m_adminPanel.setTab(USER_TAB_BROWSE_INDEX, state);
    }
}
