/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.PageState;
import java.math.BigDecimal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.EmailAddress;

import javax.mail.internet.InternetAddress;
import com.arsdigita.bebop.FormProcessException;
/**
 * Edit group form.
 *
 * @author David Dao
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupEditForm.java#8 $
 */
class GroupEditForm extends GroupForm implements AdminConstants,
                                                 FormInitListener,
                                                 FormProcessListener {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/admin/GroupEditForm.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private GroupAdministrationTab m_parent;

    public GroupEditForm() {
        this(null);
    }

    public GroupEditForm(GroupAdministrationTab parent) {
        super(GROUP_FORM_EDIT);
        addInitListener(this);
        addProcessListener(this);

        m_parent = parent;
    }
    /**
     * Initializes form elements by retrieving their values from the
     * database.
     */
    public void init(FormSectionEvent e) {
        PageState ps = e.getPageState();

        BigDecimal id = (BigDecimal) ps.getValue(GROUP_ID_PARAM);

        if (id != null) {
            Group group = new Group(id);

            m_name.setValue(ps, group.getName());
            m_email.setValue(ps, group.getPrimaryEmail());
        }
    }


    /**
     * Processes the form.
     */
    public void process(FormSectionEvent e)
        throws FormProcessException {

        PageState ps = e.getPageState();

        Group group;

        BigDecimal id = (BigDecimal) ps.getValue(GROUP_ID_PARAM);

        if (id == null) {
            throw new FormProcessException("id is null");
        }

        try {
            group = new Group(id);
        } catch (DataObjectNotFoundException exc) {
            throw new FormProcessException
                ("Couldn't find the specified group", exc);
        }

        String name = (String) m_name.getValue(ps);
        group.setName(name);

        // Workaround for bug #189720: there is no way to remove a
        // Party's primary email address, so we set it directly to
        // null if it's value on the form is null.

        InternetAddress email = (InternetAddress) m_email.getValue(ps);
        if (email != null) {
            group.setPrimaryEmail(new EmailAddress(email.getAddress()));
        } else {
            //group.set("primaryEmail", null);
            group.setPrimaryEmail(null);
        }

        group.save();

        if (m_parent != null) {
            m_parent.displayGroupInfoPanel(ps);
        }
    }

}
