/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.User;
import java.math.BigDecimal;
import java.math.BigDecimal;
import java.util.Iterator;

/**
 * Used to display and manage the list of additional email addresses
 * for a user.
 */

class EmailList extends List
    implements ListCellRenderer,
               AdminConstants,
               ActionListener
{

    /**
     * Constructor
     */

    public EmailList() {
        setModelBuilder(new EmailListModelBuilder());
        setCellRenderer(this);
        addActionListener(this);
    }

    public Component getComponent(List list,
                                  PageState state,
                                  Object value,
                                  String key,
                                  int index,
                                  boolean isSelected)
    {
        SimpleContainer c = new SimpleContainer();

        if (value != null) {
            ControlLink link =
                new ControlLink(USER_FORM_DELETE_ADDITIONAL_EMAIL);
            link.setClassAttr("deleteLink");

            c.add(new Label(value.toString()));
            c.add(link);
        }

        return c;
    }

    /**
     * This actionlister is executed when the user clicks the "delete"
     * link next to an email address.
     */

    public void actionPerformed (ActionEvent e) {
        PageState ps = e.getPageState();

        BigDecimal userID = (BigDecimal) ps.getValue(USER_ID_PARAM);
        if (userID != null) {
            User user = null;
            try {
                user = User.retrieve(userID);
            } catch (DataObjectNotFoundException exc) {
                // Ignore this exception
                return;
            }

            String email = (String) getSelectedKey(ps);
            if (email != null) {
                EmailAddress addr = new EmailAddress(email);
                user.removeEmailAddress(addr);
                user.save();
            }
        }
    }
}

class EmailListModelBuilder extends LockableImpl
    implements ListModelBuilder,
               AdminConstants
{

    private class EmailListModel implements ListModel {
        private Iterator m_emails;
        private EmailAddress m_currentEmail;

        public EmailListModel(Iterator emails) {
            m_emails = emails;
        }

        public boolean next() {
            if (m_emails.hasNext()) {
                m_currentEmail = (EmailAddress) m_emails.next();
                return true;
            } else {
                return false;
            }
        }

        public String getKey() {
            return m_currentEmail.getEmailAddress();
        }

        public Object getElement() {
            return m_currentEmail.getEmailAddress();
        }
    }

    public ListModel makeModel(List l, PageState state) {

        BigDecimal userID = (BigDecimal)state.getValue(USER_ID_PARAM);

        if (userID == null) {
            return null;
        }

        User user = User.retrieve(userID);
        // Generate the list of non-primary addresses.
        return new EmailListModel(user.getAlternateEmails());
    }
}
