/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PageEvent;
import com.arsdigita.persistence.DataQuery;

/**
 * This event is fired by the {@link DataQuery} class
 *
 * @see DataQuery
 * @see QueryListener
 */
public class QueryEvent extends PageEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/QueryEvent.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private DataQuery m_query;

    public QueryEvent(Component source, PageState s, DataQuery q) {
        super(source, s);
        m_query = q;
    }

    public DataQuery getDataQuery() {
        return m_query;
    }

}
