/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import javax.servlet.http.HttpServletRequest;
import com.arsdigita.persistence.OID;
import com.arsdigita.bebop.parameters.ParameterModel;

/*
 * A {@link com.arsdigita.bebop.parameters.ParameterModel} for an
 * {@link com.arsdigita.persistence.OID}
 *
 * @author Patrick McNeill
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/OIDParameter.java#7 $
 * @since Iteration 1
 */
public class OIDParameter extends ParameterModel {
    public OIDParameter(String name) {
        super(name);
    }

    public Object transformValue(HttpServletRequest request) {
        return transformSingleValue(request);
    }

    public Object unmarshal(String encoded) {
        if (encoded.equals("")) {
            return null;
        } else {
            return OID.valueOf(java.net.URLDecoder.decode(encoded));
        }
    }

    public Class getValueClass() {
        return OID.class;
    }
}
