/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class ItemEditor extends ModalContainer {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ItemEditor.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ItemEditor.class);

    private Label m_heading = null;
    private Component m_summary = null;
    private Component m_details = null;
    private ActionLink m_editLink = null;
    private Form m_edit = null;
    private ActionLink m_deleteLink = null;
    private Form m_delete = null;
    private ActionLink m_returnLink = null;

    public final void setSummary(final Label heading,
                                  final Component summary) {
        Assert.assertNotNull(heading, "Label heading");
        Assert.assertNotNull(summary, "Component summary");
        Assert.assertNotLocked(this);

        m_heading = heading;
        m_summary = summary;
    }

    public final void setDetails(final Component details) {
        Assert.assertNotNull(details, "Component details");
        Assert.assertNotLocked(this);

        m_details = details;
    }

    public final void setEdit(final ActionLink editLink,
                              final Form edit) {
        Assert.assertNotNull(editLink, "ActionLink editLink");
        Assert.assertNotNull(edit, "Form edit");
        Assert.assertNotLocked(this);

        m_editLink = editLink;
        m_edit = edit;
    }

    public final void setDelete(final ActionLink deleteLink,
                                final Form delete) {
        Assert.assertNotNull(deleteLink, "ActionLink deleteLink");
        Assert.assertNotNull(delete, "Form delete");
        Assert.assertNotLocked(this);

        m_deleteLink = deleteLink;
        m_delete = delete;
    }

    public final void setReturn(final ActionLink returnLink) {
        Assert.assertNotNull(returnLink, "ActionLink returnLink");
        Assert.assertNotLocked(this);

        m_returnLink = returnLink;
    }

    public void register(final Page page) {
        Assert.assertNotNull(m_heading, "Label m_heading");
        Assert.assertNotNull(m_summary, "Component m_summary");

        final SimpleContainer info = new SimpleContainer();
        super.setDefaultComponent(info);

        info.add(new Summary());

        if (m_details != null) {
            info.add(m_details);
        }

        if (m_edit != null) {
            add(m_edit);

            // XXX if we use FormPrimes, do cancel logic here too.

            m_edit.addProcessListener(new FormProcessListener() {
                    public final void process(final FormSectionEvent e) {
                        ItemEditor.this.reset(e.getPageState());
                    }
                });
        }

        if (m_delete != null) {
            add(m_delete);

            // XXX if we use FormPrimes, do cancel logic here too.

            m_delete.addProcessListener(new FormProcessListener() {
                    public final void process(final FormSectionEvent e) {
                        ItemEditor.this.reset(e.getPageState());
                    }
                });
        }

        super.register(page);
    }

    public final void setDefaultComponent(final Component component) {
        throw new UnsupportedOperationException();
    }

    private class Summary extends Section {
        Summary() {
            setHeading(m_heading);

            final ActionGroup group = new ActionGroup();
            setBody(group);

            group.setSubject(m_summary);

            if (m_editLink != null) {
                prepareEditLink();

                group.addAction(m_editLink);
            }

            if (m_deleteLink != null) {
                prepareDeleteLink();

                group.addAction(m_deleteLink);
            }

            if (m_returnLink != null) {
                group.addAction(m_returnLink);
            }
        }

        private void prepareEditLink() {
            m_editLink.addActionListener(new ActionListener() {
                    public final void actionPerformed(final ActionEvent e) {
                        ItemEditor.this.setVisibleComponent
                            (e.getPageState(), m_edit);
                    }
                });
        }

        private void prepareDeleteLink() {
            m_deleteLink.addActionListener(new ActionListener() {
                    public final void actionPerformed(final ActionEvent e) {
                        ItemEditor.this.setVisibleComponent
                            (e.getPageState(), m_delete);
                    }
                });
        }
    }
}
