/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.PageState;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

/**
 * 
 *
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DefaultItemDetailModel.java#8 $
 */
public class DefaultItemDetailModel implements ItemDetailModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DefaultItemDetailModel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_title;
    private List m_properties;
    private List m_actions;

    public DefaultItemDetailModel() {
        m_properties = new ArrayList();
        m_actions = new ArrayList();
    }

    public String getTitle(PageState pageState) {
        return m_title;
    }

    public void setTitle(String title) {
        m_title = title;
    }

    public Iterator getProperties(PageState pageState) {
        return m_properties.iterator();
    }

    public void addProperty(ItemDetailProperty property) {
        m_properties.add(property);
    }

    public void addProperty(String name, String value) {
        m_properties.add(new ItemDetailProperty(name, value));
    }

    public Iterator getActions(PageState pageState) {
        return m_actions.iterator();
    }

    public void addAction(ItemDetailAction action) {
        m_actions.add(action);
    }

    public void addAction(String name, String url) {
        m_actions.add(new ItemDetailAction(name, url));
    }
}
