/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.util.Assert;
import com.arsdigita.util.OrderedMap;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class ComponentMap extends SimpleComponent
        implements Resettable {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ComponentMap.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(ComponentMap.class);

    private final OrderedMap m_components;

    public ComponentMap() {
        m_components = new OrderedMap();
    }

    public final Iterator children() {
        return m_components.values().iterator();
    }

    public void reset(final PageState state) {
        s_log.debug("Resetting my children");

        final Iterator iter = children();

        while (iter.hasNext()) {
            final Object component = iter.next();

            if (component instanceof Resettable) {
                ((Resettable) component).reset(state);
            }
        }
    }

    public final void put(final Object key, final Component component) {
        Assert.unlocked(this);
        Assert.exists(key, Object.class);

        m_components.put(key, component);
    }

    public final Component get(final Object key) {
        return (Component) m_components.get(key);
    }

    public final boolean containsKey(final Object key) {
        return m_components.containsKey(key);
    }

    public final boolean containsValue(final Component component) {
        return m_components.containsValue(component);
    }

    public abstract void generateXML(final PageState state,
                                     final Element parent);
}
