/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.rebop;

import java.awt.Graphics;

/**
 * Interface for simple drawable objects. Implement this
 * for objects that will be used to visually render
 * a GenericComponent subclass.
 *
 * @author Gavin Doughtie
 * @see AbstractDrawable
 * @see BevelBox
 * @see StyledText
 */

public interface GenericDrawable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/GenericDrawable.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * This is the main GenericDrawable method implementors will define.
     * The other methods can typically be inherited from AbstractDrawable.
     * @param g Graphics to draw on
     * @param x horizontal location to begin drawing
     * @param y vertical location to begin drawing
     * @param width width of area to draw in
     * @param height height of area to draw in
     */
    void draw(Graphics g, int x, int y, int width, int height);

    // Offsets are used mainly for button pushdowns

    /**
     * The X and Y offsets are used to offset a drawable from the location
     * where it is told to draw. Offsets are typically used for drawables
     * that are inside components that form the contents of a push-down
     * button.
     * @param xOffset number of horizontal pixels to offset this
     * drawable before drawing it.
     */
    void setXOffset(int xOffset);
    int getXOffset();

    /**
     * @param yOffset number of vertical pixels to offset this
     * @see #setXOffset(int)
     */
    void setYOffset(int yOffset);
    int getYOffset();

}// GenericDrawable
